<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Taskrouter
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Taskrouter\V1\Workspace\Worker;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class ReservationContext extends InstanceContext
    {
    /**
     * Initialize the ReservationContext
     *
     * @param Version $version Version that contains the resource
     * @param string $workspaceSid The SID of the Workspace with the WorkerReservation resource to fetch.
     * @param string $workerSid The SID of the reserved Worker resource with the WorkerReservation resource to fetch.
     * @param string $sid The SID of the WorkerReservation resource to fetch.
     */
    public function __construct(
        Version $version,
        $workspaceSid,
        $workerSid,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'workspaceSid' =>
            $workspaceSid,
        'workerSid' =>
            $workerSid,
        'sid' =>
            $sid,
        ];

        $this->uri = '/Workspaces/' . \rawurlencode($workspaceSid)
        .'/Workers/' . \rawurlencode($workerSid)
        .'/Reservations/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the ReservationInstance
     *
     * @return ReservationInstance Fetched ReservationInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ReservationInstance
    {
        $response = $this->_fetch();
        return new ReservationInstance(
            $this->version,
            $response->getContent(),
            $this->solution['workspaceSid'],
            $this->solution['workerSid'],
            $this->solution['sid']
        );
        
    }

    /**
     * Fetch the ReservationInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new ReservationInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['workspaceSid'],
                        $this->solution['workerSid'],
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'ReservationStatus' =>
                $options['reservationStatus'],
            'WorkerActivitySid' =>
                $options['workerActivitySid'],
            'Instruction' =>
                $options['instruction'],
            'DequeuePostWorkActivitySid' =>
                $options['dequeuePostWorkActivitySid'],
            'DequeueFrom' =>
                $options['dequeueFrom'],
            'DequeueRecord' =>
                $options['dequeueRecord'],
            'DequeueTimeout' =>
                $options['dequeueTimeout'],
            'DequeueTo' =>
                $options['dequeueTo'],
            'DequeueStatusCallbackUrl' =>
                $options['dequeueStatusCallbackUrl'],
            'CallFrom' =>
                $options['callFrom'],
            'CallRecord' =>
                $options['callRecord'],
            'CallTimeout' =>
                $options['callTimeout'],
            'CallTo' =>
                $options['callTo'],
            'CallUrl' =>
                $options['callUrl'],
            'CallStatusCallbackUrl' =>
                $options['callStatusCallbackUrl'],
            'CallAccept' =>
                Serialize::booleanToString($options['callAccept']),
            'RedirectCallSid' =>
                $options['redirectCallSid'],
            'RedirectAccept' =>
                Serialize::booleanToString($options['redirectAccept']),
            'RedirectUrl' =>
                $options['redirectUrl'],
            'To' =>
                $options['to'],
            'From' =>
                $options['from'],
            'StatusCallback' =>
                $options['statusCallback'],
            'StatusCallbackMethod' =>
                $options['statusCallbackMethod'],
            'StatusCallbackEvent' =>
                $options['statusCallbackEvent'],
            'Timeout' =>
                $options['timeout'],
            'Record' =>
                Serialize::booleanToString($options['record']),
            'Muted' =>
                Serialize::booleanToString($options['muted']),
            'Beep' =>
                $options['beep'],
            'StartConferenceOnEnter' =>
                Serialize::booleanToString($options['startConferenceOnEnter']),
            'EndConferenceOnExit' =>
                Serialize::booleanToString($options['endConferenceOnExit']),
            'WaitUrl' =>
                $options['waitUrl'],
            'WaitMethod' =>
                $options['waitMethod'],
            'EarlyMedia' =>
                Serialize::booleanToString($options['earlyMedia']),
            'MaxParticipants' =>
                $options['maxParticipants'],
            'ConferenceStatusCallback' =>
                $options['conferenceStatusCallback'],
            'ConferenceStatusCallbackMethod' =>
                $options['conferenceStatusCallbackMethod'],
            'ConferenceStatusCallbackEvent' =>
                $options['conferenceStatusCallbackEvent'],
            'ConferenceRecord' =>
                $options['conferenceRecord'],
            'ConferenceTrim' =>
                $options['conferenceTrim'],
            'RecordingChannels' =>
                $options['recordingChannels'],
            'RecordingStatusCallback' =>
                $options['recordingStatusCallback'],
            'RecordingStatusCallbackMethod' =>
                $options['recordingStatusCallbackMethod'],
            'ConferenceRecordingStatusCallback' =>
                $options['conferenceRecordingStatusCallback'],
            'ConferenceRecordingStatusCallbackMethod' =>
                $options['conferenceRecordingStatusCallbackMethod'],
            'Region' =>
                $options['region'],
            'SipAuthUsername' =>
                $options['sipAuthUsername'],
            'SipAuthPassword' =>
                $options['sipAuthPassword'],
            'DequeueStatusCallbackEvent' =>
                Serialize::map($options['dequeueStatusCallbackEvent'], function ($e) { return $e; }),
            'PostWorkActivitySid' =>
                $options['postWorkActivitySid'],
            'EndConferenceOnCustomerExit' =>
                Serialize::booleanToString($options['endConferenceOnCustomerExit']),
            'BeepOnCustomerEntrance' =>
                Serialize::booleanToString($options['beepOnCustomerEntrance']),
            'JitterBufferSize' =>
                $options['jitterBufferSize'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' , 'If-Match' => $options['ifMatch']]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the ReservationInstance
     *
     * @param array|Options $options Optional Arguments
     * @return ReservationInstance Updated ReservationInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): ReservationInstance
    {
        $response = $this->_update($options);
        return new ReservationInstance(
            $this->version,
            $response->getContent(),
            $this->solution['workspaceSid'],
            $this->solution['workerSid'],
            $this->solution['sid']
        );
        
    }

    /**
     * Update the ReservationInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new ReservationInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['workspaceSid'],
                        $this->solution['workerSid'],
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Taskrouter.V1.ReservationContext ' . \implode(' ', $context) . ']';
    }
}
