<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Taskrouter
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Taskrouter\V1\Workspace\TaskQueue;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class TaskQueueBulkRealTimeStatisticsList extends ListResource
    {
    /**
     * Construct the TaskQueueBulkRealTimeStatisticsList
     *
     * @param Version $version Version that contains the resource
     * @param string $workspaceSid The unique SID identifier of the Workspace.
     */
    public function __construct(
        Version $version,
        string $workspaceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'workspaceSid' =>
            $workspaceSid,
        
        ];

        $this->uri = '/Workspaces/' . \rawurlencode($workspaceSid)
        .'/TaskQueues/RealTimeStatistics';
    }

    /**
     * Helper function for Create
     *
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $body->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the TaskQueueBulkRealTimeStatisticsInstance
     *
     * @return TaskQueueBulkRealTimeStatisticsInstance Created TaskQueueBulkRealTimeStatisticsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(): TaskQueueBulkRealTimeStatisticsInstance
    {
        $response = $this->_create();
        return new TaskQueueBulkRealTimeStatisticsInstance(
            $this->version,
            $response->getContent(),
            $this->solution['workspaceSid']
        );
        
    }

    /**
     * Create the TaskQueueBulkRealTimeStatisticsInstance with Metadata
     *
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(): ResourceMetadata
    {
        $response = $this->_create();
        $resource = new TaskQueueBulkRealTimeStatisticsInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['workspaceSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Taskrouter.V1.TaskQueueBulkRealTimeStatisticsList]';
    }
}
