<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Marketplace
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Marketplace\V1;

use Twilio\ListResource;
use Twilio\Stream;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ArrayMetadata;
use Twilio\Metadata\PageMetadata;
use Twilio\Metadata\StreamMetadata;


class AvailableAddOnList extends ListResource
    {
    /**
     * Construct the AvailableAddOnList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/AvailableAddOns';
    }

    /**
     * Reads AvailableAddOnInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return AvailableAddOnInstance[] Array of results
     */
    public function read(?int $limit = null, $pageSize = null): array
    {
        return \iterator_to_array($this->stream($limit, $pageSize), false);
    }

    /**
     * Reads AvailableAddOnInstance records from the API as a list
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return ArrayMetadata Array of results along with metadata
     */
    public function readWithMetadata(?int $limit = null, $pageSize = null): ArrayMetadata
    {
        $streamWithMetadata = $this->streamWithMetadata($limit, $pageSize);
        $readResponse = \iterator_to_array($streamWithMetadata, false);
        return new ArrayMetadata(
            $readResponse,
            $streamWithMetadata->getStatusCode(),
            $streamWithMetadata->getHeaders()
        );
    }

    /**
     * Streams AvailableAddOnInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return Stream stream of results
     */
    public function stream(?int $limit = null, $pageSize = null): Stream
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Streams AvailableAddOnInstance records from the API as a generator stream and returns result with Metadata
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return StreamMetadata stream of results with metadata
     */
    public function streamWithMetadata(?int $limit = null, $pageSize = null): StreamMetadata
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $pageWithMetadata = $this->pageWithMetadata($limits['pageSize']);

        $stream = $this->version->stream($pageWithMetadata->getPage(), $limits['limit'], $limits['pageLimit']);

        return new StreamMetadata(
            $stream,
            $pageWithMetadata->getStatusCode(),
            $pageWithMetadata->getHeaders()
        );
    }

    /**
     * Helper function for Page
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return Response Paged Response
     */
    private function _page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): Response
    {

        $params = Values::of([
            'PageToken' => $pageToken,
            'Page' => $pageNumber,
            'PageSize' => $pageSize,
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json']);
        return $this->version->page('GET', $this->uri, $params, [], $headers);
    }

    /**
     * Retrieve a single page of AvailableAddOnInstance records from the API.
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return AvailableAddOnPage Page of AvailableAddOnInstance
     */
    public function page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): AvailableAddOnPage
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        return new AvailableAddOnPage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a single page of AvailableAddOnInstance records with metadata
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return PageMetadata of AvailableAddOnInstance
     */
    public function pageWithMetadata(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): PageMetadata
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        $resource =  new AvailableAddOnPage($this->version, $response, $this->solution);

        return new PageMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }

    /**
     * Retrieve a specific page of AvailableAddOnInstance records from the API.
     * Request is executed immediately
     *
     * @param string $targetUrl API-generated URL for the requested results page
     * @return AvailableAddOnPage Page of AvailableAddOnInstance
     */
    public function getPage(string $targetUrl): AvailableAddOnPage
    {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new AvailableAddOnPage($this->version, $response, $this->solution);
    }


    /**
     * Constructs a AvailableAddOnContext
     *
     * @param string $sid The SID of the AvailableAddOn resource to fetch.
     */
    public function getContext(
        string $sid
        
    ): AvailableAddOnContext
    {
        return new AvailableAddOnContext(
            $this->version,
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Marketplace.V1.AvailableAddOnList]';
    }
}
