<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Bulkexports
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Bulkexports\V1\Export;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class DayContext extends InstanceContext
    {
    /**
     * Initialize the DayContext
     *
     * @param Version $version Version that contains the resource
     * @param string $resourceType The type of communication – Messages, Calls, Conferences, and Participants
     * @param string $day The ISO 8601 format date of the resources in the file, for a UTC day
     */
    public function __construct(
        Version $version,
        $resourceType,
        $day
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'resourceType' =>
            $resourceType,
        'day' =>
            $day,
        ];

        $this->uri = '/Exports/' . \rawurlencode($resourceType)
        .'/Days/' . \rawurlencode($day)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the DayInstance
     *
     * @return DayInstance Fetched DayInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): DayInstance
    {
        $response = $this->_fetch();
        return new DayInstance(
            $this->version,
            $response->getContent(),
            $this->solution['resourceType'],
            $this->solution['day']
        );
        
    }

    /**
     * Fetch the DayInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new DayInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['resourceType'],
                        $this->solution['day']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Bulkexports.V1.DayContext ' . \implode(' ', $context) . ']';
    }
}
